/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event;

import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RankPointHandler {
    public static RankPointHandler getInstance() {
        return SingletonHolder.instance;
    }

    private RankPointHandler() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDeathEvent(LivingHurtEvent event) {
        Entity trueSource;
        LivingEntity victim = event.getEntity();
        if (victim != null) {
            victim.getCapability(CapabilityConcentrationRank.RANK_POINT).ifPresent(cr -> cr.addRankPoint(victim, -cr.getUnitCapacity()));
        }
        if (!((trueSource = event.getSource().m_7639_()) instanceof LivingEntity)) {
            return;
        }
        trueSource.getCapability(CapabilityConcentrationRank.RANK_POINT).ifPresent(cr -> cr.addRankPoint(event.getSource()));
    }

    private static final class SingletonHolder {
        private static final RankPointHandler instance = new RankPointHandler();

        private SingletonHolder() {
        }
    }
}

